/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x13.regarima;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import jdplus.sa.base.api.ComponentType;
import jdplus.sa.base.api.EstimationPolicyType;
import jdplus.toolkit.base.api.arima.SarimaSpec;
import jdplus.toolkit.base.api.data.Parameter;
import jdplus.toolkit.base.api.data.Range;
import jdplus.toolkit.base.api.modelling.TransformationType;
import jdplus.toolkit.base.api.timeseries.TimeSelector;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.calendars.LengthOfPeriodType;
import jdplus.toolkit.base.api.timeseries.calendars.TradingDaysType;
import jdplus.toolkit.base.api.timeseries.regression.EasterVariable;
import jdplus.toolkit.base.api.timeseries.regression.IOutlier;
import jdplus.toolkit.base.api.timeseries.regression.ITradingDaysVariable;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.api.timeseries.regression.InterventionVariable;
import jdplus.toolkit.base.api.timeseries.regression.JulianEasterVariable;
import jdplus.toolkit.base.api.timeseries.regression.ModellingUtility;
import jdplus.toolkit.base.api.timeseries.regression.Ramp;
import jdplus.toolkit.base.api.timeseries.regression.TsContextVariable;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.modelling.GeneralLinearModel;
import jdplus.x13.base.api.regarima.AutoModelSpec;
import jdplus.x13.base.api.regarima.EasterSpec;
import jdplus.x13.base.api.regarima.MeanSpec;
import jdplus.x13.base.api.regarima.OutlierSpec;
import jdplus.x13.base.api.regarima.RegArimaSpec;
import jdplus.x13.base.api.regarima.RegressionSpec;
import jdplus.x13.base.api.regarima.RegressionTestSpec;
import jdplus.x13.base.api.regarima.TradingDaysSpec;
import jdplus.x13.base.api.regarima.TransformSpec;

public class RegArimaFactory {
    private static final RegArimaFactory INSTANCE = new RegArimaFactory();
    private static final Map<String, String> IV_AO = RegArimaFactory.ao_attributes();

    public static RegArimaFactory getInstance() {
        return INSTANCE;
    }

    public RegArimaSpec generateSpec(RegArimaSpec spec, GeneralLinearModel.Description<SarimaSpec> desc) {
        RegArimaSpec.Builder builder = spec.toBuilder();
        this.update(spec.getTransform(), desc, builder);
        this.update(spec.getArima(), desc, builder);
        this.update(spec.getAutoModel(), desc, builder);
        this.update(spec.getOutliers(), desc, builder);
        this.update(spec.getRegression(), desc, builder);
        return (RegArimaSpec)builder.build();
    }

    public RegArimaSpec refreshSpec(RegArimaSpec currentSpec, RegArimaSpec domainSpec, EstimationPolicyType policy, TsDomain frozenDomain) {
        if (policy == EstimationPolicyType.Complete) {
            return domainSpec;
        }
        if (policy == EstimationPolicyType.None || !currentSpec.getBasic().isPreprocessing()) {
            return currentSpec;
        }
        RegArimaSpec.Builder builder = currentSpec.toBuilder();
        switch (policy) {
            case Outliers_StochasticComponent: {
                this.resetArima(currentSpec, domainSpec, builder);
                RegressionSpec rspec = this.removeOutliers(currentSpec, domainSpec, builder, frozenDomain);
                this.freeVariables(rspec, domainSpec, builder);
                break;
            }
            case Outliers: {
                this.clearArima(currentSpec, domainSpec, builder);
                RegressionSpec rspec = this.removeOutliers(currentSpec, domainSpec, builder, frozenDomain);
                this.freeVariables(rspec, domainSpec, builder);
                break;
            }
            case LastOutliers: {
                this.clearArima(currentSpec, domainSpec, builder);
                RegressionSpec rspec = this.removeOutliers(currentSpec, domainSpec, builder, frozenDomain);
                this.freeVariables(rspec, domainSpec, builder);
                break;
            }
            case FreeParameters: {
                this.freeArima(currentSpec, domainSpec, builder);
                this.freeVariables(currentSpec.getRegression(), domainSpec, builder);
                break;
            }
            case FixedAutoRegressiveParameters: {
                this.fixAR(currentSpec, domainSpec, builder);
                this.freeVariables(currentSpec.getRegression(), domainSpec, builder);
                break;
            }
            case FixedParameters: {
                this.fixArima(currentSpec, domainSpec, builder);
                this.freeVariables(currentSpec.getRegression(), domainSpec, builder);
                break;
            }
            case Fixed: 
            case Current: {
                this.fixArima(currentSpec, domainSpec, builder);
                this.fixVariables(currentSpec.getRegression(), domainSpec, builder, frozenDomain);
                break;
            }
            default: {
                return currentSpec;
            }
        }
        return (RegArimaSpec)builder.build();
    }

    private void update(TransformSpec transform, GeneralLinearModel.Description<SarimaSpec> rslts, RegArimaSpec.Builder builder) {
        if (transform.getFunction() == TransformationType.Auto) {
            TransformSpec ntransform = (TransformSpec)transform.toBuilder().function(rslts.isLogTransformation() ? TransformationType.Log : TransformationType.None).adjust(rslts.getLengthOfPeriodTransformation()).build();
            builder.transform(ntransform);
        }
    }

    private void update(SarimaSpec arima, GeneralLinearModel.Description<SarimaSpec> rslts, RegArimaSpec.Builder builder) {
        SarimaSpec nspec = (SarimaSpec)rslts.getStochasticComponent();
        builder.arima(nspec);
    }

    private void update(AutoModelSpec ami, GeneralLinearModel.Description<SarimaSpec> rslts, RegArimaSpec.Builder builder) {
        AutoModelSpec nami = (AutoModelSpec)ami.toBuilder().enabled(false).build();
        builder.autoModel(nami);
    }

    private void update(OutlierSpec outliers, GeneralLinearModel.Description<SarimaSpec> rslts, RegArimaSpec.Builder builder) {
        if (outliers.isUsed()) {
            builder.outliers((OutlierSpec)outliers.toBuilder().clearTypes().build());
        }
    }

    private void update(RegressionSpec regression, GeneralLinearModel.Description<SarimaSpec> rslts, RegArimaSpec.Builder builder) {
        RegressionSpec.Builder rbuilder = regression.toBuilder();
        Variable[] variables = rslts.getVariables();
        this.updateMean(variables, rbuilder);
        this.update(regression.getTradingDays(), variables, rbuilder);
        this.update(regression.getEaster(), variables, rbuilder);
        this.updateOutliers(variables, rbuilder);
        this.updateUserVariables(variables, rbuilder);
        builder.regression((RegressionSpec)rbuilder.build());
    }

    private void updateMean(Variable[] vars, RegressionSpec.Builder builder) {
        Optional<Variable> fc = Arrays.stream(vars).filter(v -> v.getName().equals("const")).findFirst();
        if (fc.isPresent()) {
            builder.mean(MeanSpec.mean((Parameter)fc.orElseThrow().getCoefficient(0)));
        } else {
            builder.mean(MeanSpec.DEFAULT_UNUSED);
        }
    }

    private void update(TradingDaysSpec tdspec, Variable[] vars, RegressionSpec.Builder builder) {
        Optional<Variable> flp = Arrays.stream(vars).filter(v -> ModellingUtility.isLengthOfPeriod((Variable)v)).findFirst();
        Optional<Variable> ftd = Arrays.stream(vars).filter(v -> ModellingUtility.isTradingDays((Variable)v)).findFirst();
        TradingDaysSpec ntdspec = TradingDaysSpec.none();
        LengthOfPeriodType lp = LengthOfPeriodType.None;
        Parameter clp = null;
        if (flp.isPresent()) {
            Variable v2 = flp.orElseThrow();
            lp = tdspec.getLengthOfPeriodType();
            clp = v2.getCoefficient(0);
        }
        TradingDaysType td = TradingDaysType.NONE;
        Parameter[] ctd = null;
        if (ftd.isPresent()) {
            Variable v3 = ftd.orElseThrow();
            if (tdspec.isAutomatic()) {
                ITradingDaysVariable tdv = (ITradingDaysVariable)v3.getCore();
                td = tdv.getTradingDaysType();
            } else {
                td = tdspec.getTradingDaysType();
            }
            ctd = v3.getCoefficients();
        }
        if (ftd.isPresent() || flp.isPresent()) {
            if (tdspec.isStockTradingDays()) {
                int ntd = tdspec.getStockTradingDays();
                ntdspec = TradingDaysSpec.stockTradingDays((int)ntd, ctd);
            } else {
                ntdspec = tdspec.isHolidays() ? TradingDaysSpec.holidays((String)tdspec.getHolidays(), (TradingDaysType)td, (LengthOfPeriodType)lp, (Parameter[])ctd, (Parameter)clp) : (tdspec.isUserDefined() ? TradingDaysSpec.userDefined((String[])tdspec.getUserVariables(), (Parameter[])ctd) : TradingDaysSpec.td((TradingDaysType)td, (LengthOfPeriodType)lp, (Parameter[])ctd, (Parameter)clp));
            }
        }
        builder.tradingDays(ntdspec);
    }

    private void update(EasterSpec espec, Variable[] vars, RegressionSpec.Builder builder) {
        Optional<Variable> fe = Arrays.stream(vars).filter(v -> ModellingUtility.isEaster((Variable)v)).findFirst();
        if (fe.isPresent()) {
            Variable ev = fe.orElseThrow();
            ITsVariable iTsVariable = ev.getCore();
            if (iTsVariable instanceof EasterVariable) {
                EasterVariable evar = (EasterVariable)iTsVariable;
                espec = (EasterSpec)espec.toBuilder().type(EasterSpec.Type.Easter).test(RegressionTestSpec.None).duration(evar.getDuration()).coefficient(ev.getCoefficient(0)).build();
            } else {
                iTsVariable = ev.getCore();
                if (iTsVariable instanceof JulianEasterVariable) {
                    JulianEasterVariable evar = (JulianEasterVariable)iTsVariable;
                    espec = (EasterSpec)espec.toBuilder().type(EasterSpec.Type.Easter).test(RegressionTestSpec.None).duration(evar.getDuration()).coefficient(ev.getCoefficient(0)).build();
                } else {
                    espec = EasterSpec.none();
                }
            }
        } else {
            espec = EasterSpec.none();
        }
        builder.easter(espec);
    }

    private void updateOutliers(Variable[] vars, RegressionSpec.Builder builder) {
        builder.clearOutliers();
        Arrays.stream(vars).filter(v -> ModellingUtility.isOutlier((Variable)v)).forEach(v -> builder.outlier(v.removeAttribute("ami")));
    }

    private void updateUserVariables(Variable[] vars, RegressionSpec.Builder builder) {
        builder.clearInterventionVariables();
        Arrays.stream(vars).filter(v -> v.getCore() instanceof InterventionVariable).forEach(v -> builder.interventionVariable(v));
        builder.clearRamps();
        Arrays.stream(vars).filter(v -> v.getCore() instanceof Ramp).forEach(v -> builder.ramp(v));
        builder.clearUserDefinedVariables();
        Arrays.stream(vars).filter(v -> ModellingUtility.isUser((Variable)v)).filter(v -> !(v.getCore() instanceof InterventionVariable)).filter(v -> !(v.getCore() instanceof Ramp)).map(v -> v.withCore((ITsVariable)TsContextVariable.of((ITsVariable)v.getCore()))).forEach(v -> builder.userDefinedVariable(v));
    }

    private void resetArima(RegArimaSpec currentSpec, RegArimaSpec domainSpec, RegArimaSpec.Builder builder) {
        builder.arima(domainSpec.getArima());
        builder.autoModel(domainSpec.getAutoModel());
    }

    private RegressionSpec removeOutliers(RegArimaSpec currentSpec, RegArimaSpec domainSpec, RegArimaSpec.Builder builder, TsDomain frozen) {
        OutlierSpec ospec = domainSpec.getOutliers();
        if (frozen != null) {
            ospec = (OutlierSpec)ospec.toBuilder().span(TimeSelector.from((LocalDateTime)frozen.getEndPeriod().start())).build();
        }
        builder.outliers(ospec);
        List outliers = currentSpec.getRegression().getOutliers();
        List defoutliers = domainSpec.getRegression().getOutliers();
        RegressionSpec.Builder rbuilder = currentSpec.getRegression().toBuilder().clearOutliers();
        defoutliers.forEach(outlier -> rbuilder.outlier(outlier));
        outliers.stream().filter(outlier -> !RegArimaFactory.belongsTo((Variable<IOutlier>)outlier, defoutliers)).filter(outlier -> frozen != null && frozen.contains(((IOutlier)outlier.getCore()).getPosition())).forEachOrdered(outlier -> rbuilder.outlier(outlier));
        return (RegressionSpec)rbuilder.build();
    }

    private static boolean belongsTo(Variable<IOutlier> outlier, List<Variable<IOutlier>> defoutliers) {
        return defoutliers.stream().filter(o -> ((IOutlier)o.getCore()).getCode().equals(((IOutlier)outlier.getCore()).getCode())).anyMatch(o -> ((IOutlier)o.getCore()).getPosition().equals(((IOutlier)outlier.getCore()).getPosition()));
    }

    private void clearArima(RegArimaSpec currentSpec, RegArimaSpec domainSpec, RegArimaSpec.Builder builder) {
        builder.arima(currentSpec.getArima().resetParameters(domainSpec.isUsingAutoModel() ? null : domainSpec.getArima()));
    }

    private void freeArima(RegArimaSpec currentSpec, RegArimaSpec domainSpec, RegArimaSpec.Builder builder) {
        builder.arima(currentSpec.getArima().freeParameters(domainSpec.isUsingAutoModel() ? null : domainSpec.getArima()));
    }

    private void fixAR(RegArimaSpec currentSpec, RegArimaSpec domainSpec, RegArimaSpec.Builder builder) {
        SarimaSpec arima = currentSpec.getArima();
        Parameter[] phi = Parameter.fixParameters((Parameter[])arima.getPhi());
        Parameter[] bphi = Parameter.fixParameters((Parameter[])arima.getBphi());
        SarimaSpec.Builder abuilder = arima.toBuilder().phi(phi).bphi(bphi);
        if (domainSpec.isUsingAutoModel()) {
            abuilder.theta(Parameter.freeParameters((Parameter[])arima.getTheta())).btheta(Parameter.freeParameters((Parameter[])arima.getTheta()));
        } else {
            SarimaSpec refarima = domainSpec.getArima();
            abuilder.theta(Parameter.freeParameters((Parameter[])arima.getTheta(), (Parameter[])refarima.getTheta())).btheta(Parameter.freeParameters((Parameter[])arima.getTheta(), (Parameter[])refarima.getBtheta()));
        }
        builder.arima((SarimaSpec)abuilder.build());
    }

    private void fixArima(RegArimaSpec currentSpec, RegArimaSpec domainSpec, RegArimaSpec.Builder builder) {
        builder.arima(currentSpec.getArima().fixParameters());
    }

    private void freeVariables(RegressionSpec reg, RegArimaSpec domainSpec, RegArimaSpec.Builder builder) {
        Parameter dc;
        RegressionSpec dreg = domainSpec.getRegression();
        RegressionSpec.Builder rbuilder = reg.toBuilder();
        MeanSpec mean = reg.getMean();
        if (mean.hasFixedCoefficient() && !dreg.getMean().hasFixedCoefficient()) {
            mean = MeanSpec.mean((Parameter)Parameter.initial((double)mean.getCoefficient().getValue()));
        }
        List iv = reg.getInterventionVariables();
        ArrayList niv = new ArrayList();
        iv.forEach(v -> niv.add(v.withCoefficients(RegArimaFactory.freeCoefficients(v, dreg.getInterventionVariables()))));
        List o = reg.getOutliers();
        ArrayList no = new ArrayList();
        o.forEach(v -> no.add(v.withCoefficients(RegArimaFactory.freeCoefficients(v, dreg.getOutliers()))));
        List r = reg.getRamps();
        ArrayList nr = new ArrayList();
        r.forEach(v -> nr.add(v.withCoefficients(RegArimaFactory.freeCoefficients(v, dreg.getRamps()))));
        List u = reg.getUserDefinedVariables();
        ArrayList nu = new ArrayList();
        u.forEach(v -> nu.add(v.withCoefficients(RegArimaFactory.freeCoefficients(v, dreg.getUserDefinedVariables()))));
        EasterSpec easter = reg.getEaster();
        Parameter c = easter.getCoefficient();
        if (c != null && c.isFixed() && ((dc = dreg.getEaster().getCoefficient()) == null || !dc.isFixed())) {
            c = Parameter.initial((double)c.getValue());
            easter = (EasterSpec)easter.toBuilder().coefficient(c).build();
        }
        TradingDaysSpec td = reg.getTradingDays();
        c = td.getLpCoefficient();
        Parameter[] tdc = td.getTdCoefficients();
        if (c != null || tdc != null) {
            Parameter dc2;
            if (c != null && c.isFixed() && ((dc2 = dreg.getTradingDays().getLpCoefficient()) == null || !dc2.isFixed())) {
                c = Parameter.initial((double)c.getValue());
            }
            tdc = Parameter.freeParameters((Parameter[])tdc, (Parameter[])dreg.getTradingDays().getTdCoefficients());
            td = td.withCoefficients(tdc, c);
        }
        builder.regression((RegressionSpec)rbuilder.mean(mean).clearInterventionVariables().interventionVariables(niv).clearOutliers().outliers(no).clearRamps().ramps(nr).clearUserDefinedVariables().userDefinedVariables(nu).easter(easter).tradingDays(td).build());
    }

    private static <S extends ITsVariable> Parameter[] freeCoefficients(Variable<S> var, List<Variable<S>> ref) {
        Parameter[] c = var.getCoefficients();
        if (c == null) {
            return null;
        }
        Optional<Variable> rvar = ref.stream().filter(v -> v.getName().equals(var.getName())).findFirst();
        if (rvar.isPresent()) {
            return Parameter.freeParameters((Parameter[])c, (Parameter[])rvar.orElseThrow().getCoefficients());
        }
        return Parameter.freeParameters((Parameter[])c);
    }

    private static Map<String, String> ao_attributes() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("ami", "x13");
        attributes.put("regeffect", ComponentType.Irregular.name());
        return attributes;
    }

    private void fixVariables(RegressionSpec reg, RegArimaSpec domainSpec, RegArimaSpec.Builder builder, TsDomain frozenDomain) {
        RegressionSpec.Builder rbuilder = reg.toBuilder();
        MeanSpec mean = reg.getMean();
        if (mean.isDefined()) {
            mean = MeanSpec.mean((Parameter)Parameter.fixed((double)mean.getCoefficient().getValue()));
        }
        List iv = reg.getInterventionVariables();
        ArrayList<Variable> niv = new ArrayList<Variable>();
        iv.forEach(v -> {
            String n = v.getName();
            if (!n.startsWith("AO:")) {
                niv.add(v.withCoefficients(Parameter.fixParameters((Parameter[])v.getCoefficients())));
            } else {
                niv.add((Variable)v);
            }
        });
        if (frozenDomain != null) {
            for (int i = 0; i < frozenDomain.getLength(); ++i) {
                TsPeriod period = frozenDomain.get(i);
                LocalDateTime day = period.start();
                InterventionVariable ao = InterventionVariable.builder().sequence(Range.of((Comparable)day, (Comparable)day)).build();
                niv.add(Variable.builder().name("AO:" + period.getStartAsShortString()).core((ITsVariable)ao).attributes(IV_AO).build());
            }
        }
        List o = reg.getOutliers();
        ArrayList no = new ArrayList();
        o.forEach(v -> no.add(v.withCoefficients(Parameter.fixParameters((Parameter[])v.getCoefficients()))));
        List r = reg.getRamps();
        ArrayList nr = new ArrayList();
        r.forEach(v -> nr.add(v.withCoefficients(Parameter.fixParameters((Parameter[])v.getCoefficients()))));
        List u = reg.getUserDefinedVariables();
        ArrayList nu = new ArrayList();
        u.forEach(v -> nu.add(v.withCoefficients(Parameter.fixParameters((Parameter[])v.getCoefficients()))));
        EasterSpec easter = reg.getEaster();
        Parameter c = easter.getCoefficient();
        if (c != null) {
            easter = (EasterSpec)easter.toBuilder().coefficient(Parameter.fixed((double)c.getValue())).build();
        }
        TradingDaysSpec td = reg.getTradingDays();
        c = td.getLpCoefficient();
        Parameter[] tdc = td.getTdCoefficients();
        if (c != null || tdc != null) {
            td = td.withCoefficients(Parameter.fixParameters((Parameter[])tdc), c == null ? null : Parameter.fixed((double)c.getValue()));
        }
        builder.regression((RegressionSpec)rbuilder.mean(mean).clearInterventionVariables().interventionVariables(niv).clearOutliers().outliers(no).clearRamps().ramps(nr).clearUserDefinedVariables().userDefinedVariables(nu).easter(easter).tradingDays(td).build());
    }
}

