/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x13.regarima;

import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaUtility;
import jdplus.toolkit.base.core.regsarima.regular.IRegressionModule;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.ProcessingResult;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;

public class MeanController
implements IRegressionModule {
    public static final String MEAN = "mean correction";
    public static final String MEAN_ADDED = "mean significant (added)";
    public static final String MEAN_REMOVED = "mean not significant (removed)";
    static final double CVAL0 = 1.96;
    static final double CVAL1 = 1.6;
    static final double CVALFINAL = 2.5;
    private final double cval;
    private final double eps = 1.0E-5;

    public MeanController(double cval) {
        this.cval = cval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessingResult test(RegSarimaModelling context) {
        ProcessingLog log = context.getLog();
        try {
            double t;
            boolean nmean;
            log.push(MEAN);
            ModelDescription desc = context.getDescription();
            RegArimaEstimation est = context.getEstimation();
            boolean mean = desc.isMean();
            if (!mean) {
                desc = ModelDescription.copyOf((ModelDescription)desc);
                desc.setMean(true);
                est = null;
            }
            if (est == null) {
                est = desc.estimate(RegArimaUtility.processor((boolean)true, (double)1.0E-5));
            }
            boolean bl = nmean = Math.abs(t = est.getConcentratedLikelihood().tstat(0, 0, false)) > this.cval;
            if (nmean == mean) {
                ProcessingResult processingResult = ProcessingResult.Unchanged;
                return processingResult;
            }
            log.info(nmean ? MEAN_ADDED : MEAN_REMOVED);
            context.getDescription().setMean(nmean);
            context.clearEstimation();
            ProcessingResult processingResult = ProcessingResult.Changed;
            return processingResult;
        }
        finally {
            log.pop();
        }
    }
}

