## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.width = 7, fig.height = 5,
  dev = "png", dev.args = list(type = "cairo-png"),
  warning = FALSE
)

## ----setup--------------------------------------------------------------------
library(HaDeX2)

## -----------------------------------------------------------------------------
rep_dat <- create_replicate_dataset(alpha_dat)
plot_replicate_histogram(rep_dat)

## -----------------------------------------------------------------------------
plot_uncertainty(alpha_dat, state = "Alpha_KSCN")

## -----------------------------------------------------------------------------
plot_peptide_mass_measurement(alpha_dat)

## -----------------------------------------------------------------------------
plot_replicate_mass_uptake(alpha_dat, sequence = "CVRSIQA", aggregated = TRUE)

## -----------------------------------------------------------------------------
bex_dat <- calculate_back_exchange(alpha_dat, state = "Alpha_KSCN")
plot_coverage_heatmap(bex_dat, value = "back_exchange")

