/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima.diagnostics;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import jdplus.toolkit.base.api.processing.Diagnostics;
import jdplus.toolkit.base.api.processing.DiagnosticsFactory;
import jdplus.toolkit.base.core.regarima.diagnostics.ResidualsDiagnostics;
import jdplus.toolkit.base.core.regarima.diagnostics.ResidualsDiagnosticsConfiguration;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModel;
import lombok.NonNull;

public class ResidualsDiagnosticsFactory<R>
implements DiagnosticsFactory<ResidualsDiagnosticsConfiguration, R> {
    public static final String NORMALITY = "normality";
    public static final String INDEPENDENCE = "independence";
    public static final String TD_PEAK = "spectral td peaks";
    public static final String S_PEAK = "spectral seas peaks";
    public static final String NAME = "Regarima residuals";
    public static List<String> ALL = Collections.unmodifiableList(Arrays.asList("normality", "independence", "spectral td peaks", "spectral seas peaks"));
    private final ResidualsDiagnosticsConfiguration config;
    protected final Function<R, RegSarimaModel> extractor;

    public ResidualsDiagnosticsFactory(@NonNull ResidualsDiagnosticsConfiguration config, @NonNull Function<R, RegSarimaModel> extractor) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (extractor == null) {
            throw new NullPointerException("extractor is marked non-null but is null");
        }
        this.config = config;
        this.extractor = extractor;
    }

    public ResidualsDiagnosticsConfiguration getConfiguration() {
        return this.config;
    }

    public ResidualsDiagnosticsFactory<R> with(@NonNull ResidualsDiagnosticsConfiguration config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        return new ResidualsDiagnosticsFactory<R>(config, this.extractor);
    }

    public String getName() {
        return NAME;
    }

    public List<String> getTestDictionary() {
        return ALL.stream().map(s -> s + ":2").collect(Collectors.toList());
    }

    public Diagnostics of(R rslts) {
        return ResidualsDiagnostics.create(this.config, this.extractor.apply(rslts));
    }
}

