/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.com.github.miachm.sods;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import standalone_spreadsheet.com.github.miachm.sods.NotAnOdsException;
import standalone_spreadsheet.com.github.miachm.sods.XmlReaderInstance;

class XmlReaderInstanceEventImpl
implements XmlReaderInstance {
    private XMLStreamReader reader;
    private String tag;
    private String characters;
    private boolean end = false;
    private Map<String, String> atributes = new HashMap<String, String>();

    XmlReaderInstanceEventImpl(XMLStreamReader reader, String tag) {
        this.reader = reader;
        this.tag = tag;
        if (reader.isStartElement()) {
            for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String name = this.qNameToString(reader.getAttributeName(i));
                String value = reader.getAttributeValue(i);
                this.atributes.put(name, value);
            }
        } else if (this.isCharacters(reader)) {
            this.characters = reader.getText();
            this.end = true;
        }
    }

    @Override
    public boolean hasNext() {
        try {
            return this.reader.hasNext() && !this.end;
        }
        catch (XMLStreamException e) {
            throw new NotAnOdsException(e);
        }
    }

    @Override
    public XmlReaderInstance nextElement(String ... names) {
        try {
            while (this.reader.hasNext() && !this.end) {
                String elementName;
                QName qName;
                this.reader.next();
                if (this.reader.isStartElement()) {
                    qName = this.reader.getName();
                    elementName = this.qNameToString(qName);
                    if (!XmlReaderInstanceEventImpl.contains(names, elementName)) continue;
                    return new XmlReaderInstanceEventImpl(this.reader, elementName);
                }
                if (this.reader.isEndElement()) {
                    qName = this.reader.getName();
                    elementName = this.qNameToString(qName);
                    if (!elementName.equals(this.tag)) continue;
                    this.end = true;
                    return null;
                }
                if (!this.isCharacters(this.reader) || !XmlReaderInstanceEventImpl.contains(names, "characters")) continue;
                return new XmlReaderInstanceEventImpl(this.reader, "characters");
            }
            return null;
        }
        catch (XMLStreamException e) {
            throw new NotAnOdsException(e);
        }
    }

    @Override
    public String getAttribValue(String name) {
        return this.atributes.get(name);
    }

    @Override
    public String getContent() {
        return this.characters;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    private boolean isCharacters(XMLStreamReader reader) {
        return reader.isCharacters() || reader.getEventType() == 12;
    }

    private String qNameToString(QName qName) {
        return qName.getPrefix() + ":" + qName.getLocalPart();
    }

    public static <String> boolean contains(String[] array, String v) {
        for (String e : array) {
            if (!e.equals(v)) continue;
            return true;
        }
        return false;
    }
}

