/*
 * Decompiled with CFR 0.152.
 */
package internal.text.base.api;

import jdplus.toolkit.base.api.design.DemetraPlusLegacy;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

@DemetraPlusLegacy
public final class XmlLegacyId {
    private static final String SEP = "@";
    private static final int NO_INDEX = -1;
    @NonNull
    private final String file;
    private final int collectionIndex;
    private final int seriesIndex;

    @NonNull
    public static XmlLegacyId collection(@NonNull String sfile, int pos) {
        if (sfile == null) {
            throw new NullPointerException("sfile is marked non-null but is null");
        }
        return new XmlLegacyId(sfile, pos, -1);
    }

    @NonNull
    public static XmlLegacyId series(@NonNull String sfile, int cpos, int spos) {
        if (sfile == null) {
            throw new NullPointerException("sfile is marked non-null but is null");
        }
        return new XmlLegacyId(sfile, cpos, spos);
    }

    public static @Nullable XmlLegacyId parse(@NonNull String monikerId) {
        if (monikerId == null) {
            throw new NullPointerException("monikerId is marked non-null but is null");
        }
        String[] parts = monikerId.split(SEP);
        if (parts.length > 3) {
            return null;
        }
        try {
            switch (parts.length) {
                case 3: {
                    return XmlLegacyId.series(parts[0], Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
                }
                case 2: {
                    return XmlLegacyId.collection(parts[0], Integer.parseInt(parts[1]));
                }
                case 1: {
                    return new XmlLegacyId(parts[0], -1, -1);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.file).append(SEP).append(this.collectionIndex);
        if (this.isSeries()) {
            builder.append(SEP).append(this.seriesIndex);
        }
        return builder.toString();
    }

    public boolean isCollection() {
        return -1 == this.seriesIndex;
    }

    public boolean isSeries() {
        return this.seriesIndex >= 0;
    }

    @Generated
    public XmlLegacyId(@NonNull String file, int collectionIndex, int seriesIndex) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        this.file = file;
        this.collectionIndex = collectionIndex;
        this.seriesIndex = seriesIndex;
    }

    @NonNull
    @Generated
    public String getFile() {
        return this.file;
    }

    @Generated
    public int getCollectionIndex() {
        return this.collectionIndex;
    }

    @Generated
    public int getSeriesIndex() {
        return this.seriesIndex;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XmlLegacyId)) {
            return false;
        }
        XmlLegacyId other = (XmlLegacyId)o;
        if (this.getCollectionIndex() != other.getCollectionIndex()) {
            return false;
        }
        if (this.getSeriesIndex() != other.getSeriesIndex()) {
            return false;
        }
        String this$file = this.getFile();
        String other$file = other.getFile();
        return !(this$file == null ? other$file != null : !this$file.equals(other$file));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCollectionIndex();
        result = result * 59 + this.getSeriesIndex();
        String $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : $file.hashCode());
        return result;
    }
}

