/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import jdplus.toolkit.base.api.util.IntList;
import jdplus.toolkit.base.core.ml.Clusterer;
import jdplus.toolkit.base.core.ml.DistanceMeasure;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class DBScan<Z>
extends Clusterer<Z, Results> {
    private final double eps;
    private final int minPts;

    public DBScan(double eps, int minPts, DistanceMeasure<Z> distance) {
        super(distance);
        this.eps = eps;
        this.minPts = minPts;
    }

    public double getEps() {
        return this.eps;
    }

    public int getMinPts() {
        return this.minPts;
    }

    @Override
    public Results cluster(IntFunction<Z> points, int size) {
        ArrayList<IntList> clusters = new ArrayList<IntList>();
        HashMap<Integer, PointStatus> visited = new HashMap<Integer, PointStatus>();
        for (int i2 = 0; i2 < size; ++i2) {
            if (visited.get(i2) != null) continue;
            IntList neighbors = this.neighbors(i2, points, size);
            if (neighbors.size() >= this.minPts) {
                IntList cluster = new IntList();
                clusters.add(this.expandCluster(cluster, i2, neighbors, points, size, visited));
                continue;
            }
            visited.put(i2, PointStatus.NOISE);
        }
        IntList noises = new IntList();
        visited.entrySet().stream().filter(entry -> entry.getValue() == PointStatus.NOISE).mapToInt(entry -> (Integer)entry.getKey()).forEach(i -> noises.add(i));
        return new Results(clusters, noises);
    }

    private IntList expandCluster(IntList cluster, int point, IntList neighbors, IntFunction<Z> points, int size, Map<Integer, PointStatus> visited) {
        cluster.add(point);
        visited.put(point, PointStatus.PART_OF_CLUSTER);
        IntList seeds = new IntList(neighbors);
        for (int index = 0; index < seeds.size(); ++index) {
            IntList currentNeighbors;
            int sidx = seeds.get(index);
            PointStatus pStatus = visited.get(sidx);
            if (pStatus == null && (currentNeighbors = this.neighbors(sidx, points, size)).size() >= this.minPts) {
                seeds = this.merge(seeds, currentNeighbors);
            }
            if (pStatus == PointStatus.PART_OF_CLUSTER) continue;
            visited.put(sidx, PointStatus.PART_OF_CLUSTER);
            cluster.add(sidx);
        }
        return cluster;
    }

    private IntList neighbors(int point, IntFunction<Z> points, int size) {
        IntList neighbors = new IntList();
        Z cur = points.apply(point);
        for (int j = 0; j < size; ++j) {
            if (point == j || !(this.distance(points.apply(j), cur) <= this.eps)) continue;
            neighbors.add(j);
        }
        return neighbors;
    }

    private IntList merge(IntList one, IntList two) {
        int i;
        if (one.isEmpty()) {
            return two;
        }
        if (two.isEmpty()) {
            return one;
        }
        IntList all = new IntList();
        int sone = one.size();
        int stwo = two.size();
        int ione = 0;
        int itwo = 0;
        int cone = one.get(ione);
        int ctwo = two.get(itwo);
        while (true) {
            if (cone == ctwo) {
                all.add(cone);
                ++itwo;
                if (++ione >= sone) break;
                cone = one.get(ione);
                if (itwo >= stwo) break;
                ctwo = two.get(itwo);
                continue;
            }
            if (cone < ctwo) {
                all.add(cone);
                if (++ione >= sone) break;
                cone = one.get(ione);
                continue;
            }
            all.add(ctwo);
            if (++itwo >= stwo) break;
            ctwo = two.get(itwo);
        }
        if (ione < sone) {
            for (i = ione; i < sone; ++i) {
                all.add(one.get(i));
            }
        }
        if (itwo < stwo) {
            for (i = itwo; i < stwo; ++i) {
                all.add(two.get(i));
            }
        }
        return one;
    }

    private static enum PointStatus {
        NOISE,
        PART_OF_CLUSTER;

    }

    public static final class Results {
        private final List<IntList> clusters;
        private final IntList noises;

        @Generated
        public Results(List<IntList> clusters, IntList noises) {
            this.clusters = clusters;
            this.noises = noises;
        }

        @Generated
        public List<IntList> getClusters() {
            return this.clusters;
        }

        @Generated
        public IntList getNoises() {
            return this.noises;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Results)) {
                return false;
            }
            Results other = (Results)o;
            List<IntList> this$clusters = this.getClusters();
            List<IntList> other$clusters = other.getClusters();
            if (this$clusters == null ? other$clusters != null : !((Object)this$clusters).equals(other$clusters)) {
                return false;
            }
            IntList this$noises = this.getNoises();
            IntList other$noises = other.getNoises();
            return !(this$noises == null ? other$noises != null : !this$noises.equals(other$noises));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<IntList> $clusters = this.getClusters();
            result = result * 59 + ($clusters == null ? 43 : ((Object)$clusters).hashCode());
            IntList $noises = this.getNoises();
            result = result * 59 + ($noises == null ? 43 : $noises.hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "DBScan.Results(clusters=" + String.valueOf(this.getClusters()) + ", noises=" + String.valueOf(this.getNoises()) + ")";
        }
    }
}

