/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.linearfilters;

import java.util.function.DoubleFunction;
import java.util.function.DoubleUnaryOperator;
import jdplus.toolkit.base.api.math.Complex;

public interface IFilter {
    public Complex frequencyResponse(double var1);

    public boolean hasLowerBound();

    public boolean hasUpperBound();

    default public DoubleFunction<Complex> frequencyResponseFunction() {
        return x -> this.frequencyResponse(x);
    }

    default public DoubleUnaryOperator gainFunction() {
        return x -> this.frequencyResponse(x).abs();
    }

    default public DoubleUnaryOperator squaredGainFunction() {
        return x -> this.frequencyResponse(x).absSquare();
    }

    default public DoubleUnaryOperator phaseFunction() {
        return x -> {
            Complex c = this.frequencyResponse(x);
            if (c.getIm() == 0.0) {
                return 0.0;
            }
            return c.arg();
        };
    }
}

