/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.diagnostics;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import jdplus.sa.base.api.SaDiagnosticsFactory;
import jdplus.sa.base.core.diagnostics.CombinedSeasonalityDiagnostics;
import jdplus.sa.base.core.diagnostics.CombinedSeasonalityDiagnosticsConfiguration;
import jdplus.sa.base.core.diagnostics.GenericSaTests;
import jdplus.toolkit.base.api.information.Explorable;
import jdplus.toolkit.base.api.processing.Diagnostics;
import lombok.NonNull;

public class CombinedSeasonalityDiagnosticsFactory<R extends Explorable>
implements SaDiagnosticsFactory<CombinedSeasonalityDiagnosticsConfiguration, R> {
    public static final String NAME = "Combined seasonality tests";
    public static final String SA = "Combined seasonality tests on sa";
    public static final String SA_LAST = "Combined seasonality tests on sa (last years)";
    public static final String IRR = "Combined seasonality tests on irregular";
    public static final String IRR_LAST = "Combined seasonality tests on irregular (last years)";
    public static final List<String> ALL = Collections.unmodifiableList(Arrays.asList("Combined seasonality tests on sa", "Combined seasonality tests on sa (last years)", "Combined seasonality tests on irregular", "Combined seasonality tests on irregular (last years)"));
    private final CombinedSeasonalityDiagnosticsConfiguration config;
    private final Function<R, GenericSaTests> extractor;

    public CombinedSeasonalityDiagnosticsFactory(@NonNull CombinedSeasonalityDiagnosticsConfiguration config, @NonNull Function<R, GenericSaTests> extractor) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (extractor == null) {
            throw new NullPointerException("extractor is marked non-null but is null");
        }
        this.config = config;
        this.extractor = extractor;
    }

    public String getName() {
        return NAME;
    }

    public List<String> getTestDictionary() {
        return ALL.stream().map(s -> s + ":2").collect(Collectors.toList());
    }

    public Diagnostics of(R rslts) {
        return CombinedSeasonalityDiagnostics.of(this.config, this.extractor.apply(rslts));
    }

    public CombinedSeasonalityDiagnosticsConfiguration getConfiguration() {
        return this.config;
    }

    public CombinedSeasonalityDiagnosticsFactory with(CombinedSeasonalityDiagnosticsConfiguration newConfig) {
        return new CombinedSeasonalityDiagnosticsFactory<R>(newConfig, this.extractor);
    }

    public SaDiagnosticsFactory.Scope getScope() {
        return SaDiagnosticsFactory.Scope.Decomposition;
    }

    public int getOrder() {
        return 10;
    }
}

