/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.tsp;

import internal.toolkit.base.tsp.InternalTsProvider;
import java.util.List;
import java.util.function.Consumer;
import jdplus.toolkit.base.tsp.DataSource;
import jdplus.toolkit.base.tsp.DataSourceListener;
import lombok.NonNull;

public interface HasDataSourceList {
    public void reload(@NonNull DataSource var1) throws IllegalArgumentException;

    @NonNull
    public List<DataSource> getDataSources();

    public void addDataSourceListener(@NonNull DataSourceListener var1);

    public void removeDataSourceListener(@NonNull DataSourceListener var1);

    @NonNull
    public static HasDataSourceList of(@NonNull String providerName, @NonNull Iterable<DataSource> dataSources, @NonNull Consumer<? super DataSource> cacheCleaner) {
        if (providerName == null) {
            throw new NullPointerException("providerName is marked non-null but is null");
        }
        if (dataSources == null) {
            throw new NullPointerException("dataSources is marked non-null but is null");
        }
        if (cacheCleaner == null) {
            throw new NullPointerException("cacheCleaner is marked non-null but is null");
        }
        return new InternalTsProvider.DataSourceListSupport(providerName, dataSources, cacheCleaner);
    }

    @NonNull
    public static HasDataSourceList of(@NonNull String providerName, @NonNull Iterable<DataSource> dataSources) {
        if (providerName == null) {
            throw new NullPointerException("providerName is marked non-null but is null");
        }
        if (dataSources == null) {
            throw new NullPointerException("dataSources is marked non-null but is null");
        }
        return HasDataSourceList.of(providerName, dataSources, InternalTsProvider.DO_NOTHING);
    }
}

