/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.xml.legacy.calendars;

import java.time.LocalDate;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import jdplus.toolkit.base.api.timeseries.ValidityPeriod;
import jdplus.toolkit.base.api.timeseries.calendars.Holiday;
import jdplus.toolkit.base.xml.legacy.XmlDateAdapter;
import jdplus.toolkit.base.xml.legacy.calendars.HolidayAdapters;
import jdplus.toolkit.base.xml.legacy.calendars.XmlDay;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SpecialDayEventType", propOrder={"day", "from", "to"})
public class XmlSpecialDayEvent {
    @XmlElement(name="Day", required=true)
    protected XmlDay day;
    @XmlElement(name="From")
    @XmlJavaTypeAdapter(value=XmlDateAdapter.class)
    protected LocalDate from;
    @XmlElement(name="To")
    @XmlJavaTypeAdapter(value=XmlDateAdapter.class)
    protected LocalDate to;
    private static final Adapter ADAPTER = new Adapter();

    public XmlDay getDay() {
        return this.day;
    }

    public void setDay(XmlDay value) {
        this.day = value;
    }

    public LocalDate getFrom() {
        return this.from;
    }

    public void setFrom(LocalDate value) {
        this.from = value;
    }

    public LocalDate getTo() {
        return this.to;
    }

    public void setTo(LocalDate value) {
        this.to = value;
    }

    public static Adapter getAdapter() {
        return ADAPTER;
    }

    public static class Adapter
    extends XmlAdapter<XmlSpecialDayEvent, Holiday> {
        public Holiday unmarshal(XmlSpecialDayEvent v) {
            Holiday sday = HolidayAdapters.getDefault().unmarshal(v.day);
            LocalDate from = v.from;
            LocalDate to = v.to;
            if (from != null || to != null) {
                return sday.forPeriod(from, to);
            }
            return sday;
        }

        public XmlSpecialDayEvent marshal(Holiday v) {
            XmlSpecialDayEvent xse = new XmlSpecialDayEvent();
            xse.day = HolidayAdapters.getDefault().marshal(v);
            ValidityPeriod validityPeriod = v.getValidityPeriod();
            if (validityPeriod != null && validityPeriod.isStartSpecified()) {
                xse.from = validityPeriod.getStart();
                if (validityPeriod.isEndSpecified()) {
                    xse.to = validityPeriod.getEnd();
                }
            }
            return xse;
        }
    }
}

