/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.functions;

import internal.toolkit.base.core.math.functions.gsl.integration.NumericalIntegrationProcessor;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import jdplus.toolkit.base.core.math.functions.NumericalIntegration;

public final class NumericalIntegrationLoader {

    public static final class Processor {
        private final Iterable<NumericalIntegration.Processor> source = ServiceLoader.load(NumericalIntegration.Processor.class);
        private final AtomicReference<NumericalIntegration.Processor> resource = new AtomicReference<NumericalIntegration.Processor>(this.doLoad());
        private final Consumer<Iterable> cleaner = loader -> ((ServiceLoader)loader).reload();

        private NumericalIntegration.Processor doLoad() {
            return StreamSupport.stream(this.source.spliterator(), false).findFirst().orElseGet(() -> new NumericalIntegrationProcessor());
        }

        public NumericalIntegration.Processor get() {
            return this.resource.get();
        }

        public void set(NumericalIntegration.Processor newValue) {
            this.resource.set(Objects.requireNonNull(newValue));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reload() {
            Iterable<NumericalIntegration.Processor> iterable = this.source;
            synchronized (iterable) {
                this.cleaner.accept(this.source);
                this.set(this.doLoad());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            Iterable<NumericalIntegration.Processor> iterable = this.source;
            synchronized (iterable) {
                this.set(this.doLoad());
            }
        }
    }
}

