/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries.calendars;

import java.time.LocalDate;
import jdplus.toolkit.base.api.timeseries.ValidityPeriod;
import jdplus.toolkit.base.api.timeseries.calendars.DayEvent;
import jdplus.toolkit.base.api.timeseries.calendars.EasterRelatedDay;
import jdplus.toolkit.base.api.timeseries.calendars.FixedDay;
import jdplus.toolkit.base.api.timeseries.calendars.Holiday;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class PrespecifiedHoliday
implements Holiday {
    @NonNull
    private final DayEvent event;
    private final int offset;
    private final double weight;
    private final ValidityPeriod validityPeriod;
    private final boolean julian;

    public static Builder builder() {
        return new Builder().validityPeriod(ValidityPeriod.ALWAYS).weight(1.0);
    }

    public Holiday rawHoliday() {
        switch (this.event) {
            case ShroveMonday: {
                return this.julian ? EasterRelatedDay.JULIAN_SHROVEMONDAY.reweight(this.weight).plus(this.offset) : EasterRelatedDay.SHROVEMONDAY.reweight(this.weight).plus(this.offset);
            }
            case ShroveTuesday: {
                return this.julian ? EasterRelatedDay.JULIAN_SHROVETUESDAY.reweight(this.weight).plus(this.offset) : EasterRelatedDay.SHROVETUESDAY.reweight(this.weight).plus(this.offset);
            }
            case AshWednesday: {
                return this.julian ? EasterRelatedDay.JULIAN_ASHWEDNESDAY.reweight(this.weight).plus(this.offset) : EasterRelatedDay.ASHWEDNESDAY.reweight(this.weight).plus(this.offset);
            }
            case Easter: {
                return this.julian ? EasterRelatedDay.JULIAN_EASTER.reweight(this.weight).plus(this.offset) : EasterRelatedDay.EASTER.reweight(this.weight).plus(this.offset);
            }
            case MaundyThursday: {
                return this.julian ? EasterRelatedDay.JULIAN_EASTERTHURSDAY.reweight(this.weight).plus(this.offset) : EasterRelatedDay.EASTERTHURSDAY.reweight(this.weight).plus(this.offset);
            }
            case GoodFriday: {
                return this.julian ? EasterRelatedDay.JULIAN_EASTERFRIDAY.reweight(this.weight).plus(this.offset) : EasterRelatedDay.EASTERFRIDAY.reweight(this.weight).plus(this.offset);
            }
            case EasterMonday: {
                return this.julian ? EasterRelatedDay.JULIAN_EASTERMONDAY.reweight(this.weight).plus(this.offset) : EasterRelatedDay.EASTERMONDAY.reweight(this.weight).plus(this.offset);
            }
            case Ascension: {
                return this.julian ? EasterRelatedDay.JULIAN_ASCENSION.reweight(this.weight).plus(this.offset) : EasterRelatedDay.ASCENSION.reweight(this.weight).plus(this.offset);
            }
            case Pentecost: {
                return this.julian ? EasterRelatedDay.JULIAN_PENTECOST.reweight(this.weight).plus(this.offset) : EasterRelatedDay.PENTECOST.reweight(this.weight).plus(this.offset);
            }
            case WhitMonday: {
                return this.julian ? EasterRelatedDay.JULIAN_WHITMONDAY.reweight(this.weight).plus(this.offset) : EasterRelatedDay.WHITMONDAY.reweight(this.weight).plus(this.offset);
            }
            case CorpusChristi: {
                return this.julian ? EasterRelatedDay.JULIAN_CORPUSCHRISTI.reweight(this.weight).plus(this.offset) : EasterRelatedDay.CORPUSCHRISTI.reweight(this.weight).plus(this.offset);
            }
            case Assumption: {
                return FixedDay.ASSUMPTION.reweight(this.weight).plus(this.offset);
            }
            case Christmas: {
                return FixedDay.CHRISTMAS.reweight(this.weight).plus(this.offset);
            }
            case NewYear: {
                return FixedDay.NEWYEAR.reweight(this.weight).plus(this.offset);
            }
            case MayDay: {
                return FixedDay.MAYDAY.reweight(this.weight).plus(this.offset);
            }
            case AllSaintsDay: {
                return FixedDay.ALLSAINTSDAY.reweight(this.weight).plus(this.offset);
            }
            case Armistice: {
                return FixedDay.ARMISTICE.reweight(this.weight).plus(this.offset);
            }
            case Halloween: {
                return FixedDay.HALLOWEEN.reweight(this.weight).plus(this.offset);
            }
        }
        return null;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public PrespecifiedHoliday reweight(double newWeight) {
        return new PrespecifiedHoliday(this.event, this.offset, newWeight, this.validityPeriod, this.julian);
    }

    @Override
    public PrespecifiedHoliday forPeriod(LocalDate start, LocalDate end) {
        if (this.validityPeriod.getStart().equals(start) && this.validityPeriod.getEnd().equals(end)) {
            return this;
        }
        return new PrespecifiedHoliday(this.event, this.offset, this.weight, ValidityPeriod.between(start, end), this.julian);
    }

    @Override
    public String display() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.event.name());
        if (this.offset < 0) {
            builder.append(this.offset);
        } else if (this.offset > 0) {
            builder.append('+').append(this.offset);
        }
        return builder.toString();
    }

    @Generated
    PrespecifiedHoliday(@NonNull DayEvent event, int offset, double weight, ValidityPeriod validityPeriod, boolean julian) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.event = event;
        this.offset = offset;
        this.weight = weight;
        this.validityPeriod = validityPeriod;
        this.julian = julian;
    }

    @NonNull
    @Generated
    public DayEvent getEvent() {
        return this.event;
    }

    @Generated
    public int getOffset() {
        return this.offset;
    }

    @Override
    @Generated
    public ValidityPeriod getValidityPeriod() {
        return this.validityPeriod;
    }

    @Generated
    public boolean isJulian() {
        return this.julian;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrespecifiedHoliday)) {
            return false;
        }
        PrespecifiedHoliday other = (PrespecifiedHoliday)o;
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        if (Double.compare(this.getWeight(), other.getWeight()) != 0) {
            return false;
        }
        if (this.isJulian() != other.isJulian()) {
            return false;
        }
        DayEvent this$event = this.getEvent();
        DayEvent other$event = other.getEvent();
        if (this$event == null ? other$event != null : !((Object)((Object)this$event)).equals((Object)other$event)) {
            return false;
        }
        ValidityPeriod this$validityPeriod = this.getValidityPeriod();
        ValidityPeriod other$validityPeriod = other.getValidityPeriod();
        return !(this$validityPeriod == null ? other$validityPeriod != null : !((Object)this$validityPeriod).equals(other$validityPeriod));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOffset();
        long $weight = Double.doubleToLongBits(this.getWeight());
        result = result * 59 + (int)($weight >>> 32 ^ $weight);
        result = result * 59 + (this.isJulian() ? 79 : 97);
        DayEvent $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : ((Object)((Object)$event)).hashCode());
        ValidityPeriod $validityPeriod = this.getValidityPeriod();
        result = result * 59 + ($validityPeriod == null ? 43 : ((Object)$validityPeriod).hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "PrespecifiedHoliday(event=" + String.valueOf((Object)this.getEvent()) + ", offset=" + this.getOffset() + ", weight=" + this.getWeight() + ", validityPeriod=" + String.valueOf(this.getValidityPeriod()) + ", julian=" + this.isJulian() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private DayEvent event;
        @Generated
        private int offset;
        @Generated
        private double weight;
        @Generated
        private ValidityPeriod validityPeriod;
        @Generated
        private boolean julian;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder event(@NonNull DayEvent event) {
            if (event == null) {
                throw new NullPointerException("event is marked non-null but is null");
            }
            this.event = event;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder offset(int offset) {
            this.offset = offset;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder weight(double weight) {
            this.weight = weight;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder validityPeriod(ValidityPeriod validityPeriod) {
            this.validityPeriod = validityPeriod;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder julian(boolean julian) {
            this.julian = julian;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull PrespecifiedHoliday build() {
            return new PrespecifiedHoliday(this.event, this.offset, this.weight, this.validityPeriod, this.julian);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "PrespecifiedHoliday.Builder(event=" + String.valueOf((Object)this.event) + ", offset=" + this.offset + ", weight=" + this.weight + ", validityPeriod=" + String.valueOf(this.validityPeriod) + ", julian=" + this.julian + ")";
        }
    }
}

