/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.composite;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfLoading;

class ComplexLoading
implements ISsfLoading {
    private final ISsfLoading[] loadings;
    private final int[] dim;
    private final int[] start;
    private final DataBlock tmp;

    ComplexLoading(int[] start, int[] dim, ISsfLoading[] ms) {
        this.loadings = ms;
        this.start = start;
        this.dim = dim;
        int n = ms.length;
        int tdim = 0;
        for (int i = 0; i < n; ++i) {
            if (dim[i] <= tdim) continue;
            tdim = dim[i];
        }
        this.tmp = DataBlock.make(tdim);
    }

    @Override
    public boolean isTimeInvariant() {
        for (int i = 0; i < this.loadings.length; ++i) {
            if (this.loadings[i].isTimeInvariant()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void Z(int pos, DataBlock z) {
        for (int i = 0; i < this.loadings.length; ++i) {
            this.loadings[i].Z(pos, z.extract(this.start[i], this.dim[i]));
        }
    }

    @Override
    public double ZX(int pos, DataBlock m) {
        double x = 0.0;
        for (int i = 0; i < this.loadings.length; ++i) {
            x += this.loadings[i].ZX(pos, m.extract(this.start[i], this.dim[i]));
        }
        return x;
    }

    @Override
    public double ZVZ(int pos, FastMatrix v) {
        double x = 0.0;
        for (int i = 0; i < this.loadings.length; ++i) {
            FastMatrix D = v.extract(this.start[i], this.dim[i], this.start[i], this.dim[i]);
            x += this.loadings[i].ZVZ(pos, D);
            for (int j = i + 1; j < this.loadings.length; ++j) {
                DataBlock cur = this.tmp.range(0, this.dim[i]);
                FastMatrix C = v.extract(this.start[j], this.dim[j], this.start[i], this.dim[i]);
                this.loadings[j].ZM(pos, C, cur);
                x += 2.0 * this.loadings[i].ZX(pos, cur);
            }
        }
        return x;
    }

    @Override
    public void VpZdZ(int pos, FastMatrix V, double d) {
        if (d == 0.0) {
            return;
        }
        for (int i = 0; i < this.loadings.length; ++i) {
            FastMatrix D = V.extract(this.start[i], this.dim[i], this.start[i], this.dim[i]);
            this.loadings[i].VpZdZ(pos, D, d);
            for (int j = i + 1; j < this.loadings.length; ++j) {
                FastMatrix CC;
                DataBlock n;
                int k;
                DataBlockIterator cols;
                FastMatrix C;
                DataBlock cur;
                if (this.dim[j] < this.dim[i]) {
                    cur = this.tmp.range(0, this.dim[j]);
                    cur.set(0.0);
                    this.loadings[j].Z(pos, cur);
                    C = V.extract(this.start[i], this.dim[i], this.start[j], this.dim[j]);
                    cols = C.columnsIterator();
                    k = 0;
                    while (cols.hasNext()) {
                        double zj = this.tmp.get(k++);
                        n = cols.next();
                        if (zj == 0.0) continue;
                        this.loadings[i].XpZd(pos, n, d * zj);
                    }
                    CC = V.extract(this.start[j], this.dim[j], this.start[i], this.dim[i]);
                    CC.copyTranspose(C);
                    continue;
                }
                cur = this.tmp.range(0, this.dim[i]);
                cur.set(0.0);
                this.loadings[i].Z(pos, cur);
                C = V.extract(this.start[j], this.dim[j], this.start[i], this.dim[i]);
                cols = C.columnsIterator();
                k = 0;
                while (cols.hasNext()) {
                    double zi = this.tmp.get(k++);
                    n = cols.next();
                    if (zi == 0.0) continue;
                    this.loadings[j].XpZd(pos, n, d * zi);
                }
                CC = V.extract(this.start[i], this.dim[i], this.start[j], this.dim[j]);
                CC.copyTranspose(C);
            }
        }
    }

    @Override
    public void XpZd(int pos, DataBlock x, double d) {
        for (int i = 0; i < this.loadings.length; ++i) {
            this.loadings[i].XpZd(pos, x.extract(this.start[i], this.dim[i]), d);
        }
    }
}

